(function ($) {
    const debounce = (callback, wait) => {
        let timeoutId = null;
        return (...args) => {
            window.clearTimeout(timeoutId);
            timeoutId = window.setTimeout(() => {
                callback.apply(null, args);
            }, wait);
        };
    }
    $(window).resize(debounce(e => {
        $('.embed.tagesschau iframe').each((index, iframe) => {
            $(iframe).attr('src', $(iframe).attr('src') + '');
        });
    }, 250));
})(app.jq);







	

